/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.webapp;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.http.AbstractAgent;
import org.apache.axis2.webapp.Action;
import org.apache.axis2.webapp.ActionResult;
import org.apache.axis2.webapp.Redirect;
import org.apache.axis2.webapp.View;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
final class AdminActions {
    private static final Log log = LogFactory.getLog(AbstractAgent.class);
    private static final String WELCOME = "welcome";
    private static final String LOGOUT = "logout";
    private static final String INDEX = "index";
    private static final String UPLOAD = "upload";
    private static final String LIST_SERVICES = "listServices";
    private static final String ENGAGE_GLOBALLY = "engageGlobally";
    private static final String ENGAGE_TO_SERVICE_GROUP = "engageToServiceGroup";
    private static final String ENGAGE_TO_SERVICE = "engageToService";
    private static final String ENGAGE_TO_OPERATION = "engageToOperation";
    private static final String DEACTIVATE_SERVICE = "deactivateService";
    private static final String ACTIVATE_SERVICE = "activateService";
    private static final String EDIT_SERVICE_PARAMETERS = "editServiceParameters";
    private static final String VIEW_OPERATION_SPECIFIC_CHAINS = "viewOperationSpecificChains";
    private static final String SELECT_SERVICE_JSP_NAME = "SelectService.jsp";
    private static final String LOGIN_JSP_NAME = "Login.jsp";
    private final ConfigurationContext configContext;
    private File serviceDir;

    public AdminActions(ConfigurationContext configContext) {
        this.configContext = configContext;
        try {
            if (configContext.getAxisConfiguration().getRepository() != null) {
                File repoDir = new File(configContext.getAxisConfiguration().getRepository().toURI());
                this.serviceDir = new File(repoDir, "services");
                if (!this.serviceDir.exists()) {
                    this.serviceDir.mkdirs();
                }
            }
        }
        catch (Exception e) {
            log.info((Object)e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
    }

    protected void populateSessionInformation(HttpServletRequest req) {
        HashMap services = this.configContext.getAxisConfiguration().getServices();
        req.getSession().setAttribute("servicemap", (Object)services);
        req.getSession().setAttribute("servicePath", (Object)this.configContext.getServicePath());
    }

    @Action(name="index")
    public View index(HttpServletRequest req) {
        return new View("admin.jsp");
    }

    @Action(name="welcome", authorizationRequired=false)
    public ActionResult welcome(HttpServletRequest req) {
        if (req.getSession(false) != null) {
            return new Redirect("logout");
        }
        if ("true".equals(req.getParameter("failed"))) {
            req.setAttribute("errorMessage", (Object)"Invalid auth credentials!");
        }
        return new View("Login.jsp");
    }

    @Action(name="upload")
    public View upload(HttpServletRequest req) {
        String hasHotDeployment = (String)this.configContext.getAxisConfiguration().getParameterValue("hotdeployment");
        String hasHotUpdate = (String)this.configContext.getAxisConfiguration().getParameterValue("hotupdate");
        req.setAttribute("hotDeployment", (Object)(hasHotDeployment.equals("true") ? "enabled" : "disabled"));
        req.setAttribute("hotUpdate", (Object)(hasHotUpdate.equals("true") ? "enabled" : "disabled"));
        return new View("upload.jsp");
    }

    @Action(name="doUpload", post=true)
    public Redirect doUpload(HttpServletRequest req) throws ServletException {
        ServletRequestContext reqContext = new ServletRequestContext(req);
        boolean isMultipart = ServletFileUpload.isMultipartContent((RequestContext)reqContext);
        if (isMultipart) {
            try {
                DiskFileItemFactory factory = new DiskFileItemFactory();
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                List items = upload.parseRequest(req);
                for (FileItem item : items) {
                    String fileName;
                    if (item.isFormField()) continue;
                    String fileExtesion = fileName = item.getName();
                    if (!(fileExtesion = fileExtesion.toLowerCase()).endsWith(".jar") && !fileExtesion.endsWith(".aar")) {
                        return new Redirect("upload").withStatus(false, "Unsupported file type " + fileExtesion);
                    }
                    String fileNameOnly = fileName.indexOf("\\") < 0 ? fileName.substring(fileName.lastIndexOf("/") + 1, fileName.length()) : fileName.substring(fileName.lastIndexOf("\\") + 1, fileName.length());
                    File uploadedFile = new File(this.serviceDir, fileNameOnly);
                    item.write(uploadedFile);
                    return new Redirect("upload").withStatus(true, "File " + fileNameOnly + " successfully uploaded");
                }
            }
            catch (Exception e) {
                return new Redirect("upload").withStatus(false, "The following error occurred: " + e.getMessage());
            }
        }
        throw new ServletException("Invalid request");
    }

    @Action(name="login", authorizationRequired=false, post=true, sessionCreationAllowed=true)
    public Redirect login(HttpServletRequest req) {
        if (req.getSession(false) != null) {
            return new Redirect("welcome");
        }
        String username = req.getParameter("userName");
        String password = req.getParameter("password");
        if (username == null || password == null || username.trim().length() == 0 || password.trim().length() == 0) {
            return new Redirect("welcome").withParameter("failed", "true");
        }
        String adminUserName = (String)this.configContext.getAxisConfiguration().getParameter("userName").getValue();
        String adminPassword = (String)this.configContext.getAxisConfiguration().getParameter("password").getValue();
        if (username.equals(adminUserName) && password.equals(adminPassword)) {
            req.getSession().setAttribute("Logged", (Object)"Yes");
            return new Redirect("index");
        }
        return new Redirect("welcome").withParameter("failed", "true");
    }

    @Action(name="editServiceParameters")
    public View editServiceParameters(HttpServletRequest req) throws AxisFault {
        String serviceName = req.getParameter("axisService");
        AxisService service = this.configContext.getAxisConfiguration().getServiceForActivation(serviceName);
        if (service.isActive()) {
            if (serviceName != null) {
                req.getSession().setAttribute("service", (Object)this.configContext.getAxisConfiguration().getService(serviceName));
            }
            req.setAttribute("serviceName", (Object)serviceName);
            req.setAttribute("parameters", (Object)AdminActions.getParameters((AxisDescription)service));
            TreeMap<String, Map> operations = new TreeMap<String, Map>();
            Iterator it = service.getOperations();
            while (it.hasNext()) {
                AxisOperation operation = (AxisOperation)it.next();
                operations.put(operation.getName().getLocalPart(), AdminActions.getParameters((AxisDescription)operation));
            }
            req.setAttribute("operations", operations);
        } else {
            req.setAttribute("status", (Object)("Service " + serviceName + " is not an active service" + ". \n Only parameters of active services can be edited."));
        }
        return new View("editServiceParameters.jsp");
    }

    private static Map<String, String> getParameters(AxisDescription description) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        for (Parameter parameter : description.getParameters()) {
            Object value;
            if (parameter.getParameterType() == 2 || !((value = parameter.getValue()) instanceof String)) continue;
            parameters.put(parameter.getName(), (String)value);
        }
        return parameters;
    }

    @Action(name="updateServiceParameters", post=true)
    public Redirect updateServiceParameters(HttpServletRequest request) throws AxisFault {
        String serviceName = request.getParameter("axisService");
        AxisService service = this.configContext.getAxisConfiguration().getService(serviceName);
        if (service != null) {
            for (Parameter parameter : service.getParameters()) {
                String para = request.getParameter(serviceName + "_" + parameter.getName());
                service.addParameter(new Parameter(parameter.getName(), (Object)para));
            }
            Iterator iterator = service.getOperations();
            while (iterator.hasNext()) {
                AxisOperation axisOperation = (AxisOperation)iterator.next();
                String op_name = axisOperation.getName().getLocalPart();
                for (Parameter parameter : axisOperation.getParameters()) {
                    String para = request.getParameter(op_name + "_" + parameter.getName());
                    axisOperation.addParameter(new Parameter(parameter.getName(), (Object)para));
                }
            }
        }
        return new Redirect("editServiceParameters").withStatus(true, "Parameters Changed Successfully.").withParameter("axisService", serviceName);
    }

    @Action(name="engageGlobally")
    public View engageGlobally(HttpServletRequest req) {
        HashMap modules = this.configContext.getAxisConfiguration().getModules();
        req.getSession().setAttribute("modulemap", (Object)modules);
        req.getSession().setAttribute("modules", null);
        return new View("engageGlobally.jsp");
    }

    @Action(name="doEngageGlobally", post=true)
    public Redirect doEngageGlobally(HttpServletRequest request) {
        String moduleName = request.getParameter("module");
        try {
            this.configContext.getAxisConfiguration().engageModule(moduleName);
            return new Redirect("engageGlobally").withStatus(true, moduleName + " module engaged globally successfully");
        }
        catch (AxisFault axisFault) {
            return new Redirect("engageGlobally").withStatus(false, axisFault.getMessage());
        }
    }

    @Action(name="engageToOperation")
    public View engageToOperation(HttpServletRequest req) throws AxisFault {
        HashMap modules = this.configContext.getAxisConfiguration().getModules();
        req.getSession().setAttribute("modulemap", (Object)modules);
        req.getSession().setAttribute("engagestatus", null);
        req.getSession().setAttribute("modules", null);
        String serviceName = req.getParameter("axisService");
        if (serviceName != null) {
            req.setAttribute("service", (Object)serviceName);
        }
        req.getSession().setAttribute("operationmap", (Object)this.configContext.getAxisConfiguration().getService(serviceName).getOperations());
        req.getSession().setAttribute("operation", null);
        return new View("engageToOperation.jsp");
    }

    @Action(name="doEngageToOperation", post=true)
    public Redirect doEngageToOperation(HttpServletRequest request) {
        String moduleName = request.getParameter("module");
        String serviceName = request.getParameter("service");
        String operationName = request.getParameter("axisOperation");
        Redirect redirect = new Redirect("engageToOperation").withParameter("axisService", serviceName);
        try {
            AxisOperation od = this.configContext.getAxisConfiguration().getService(serviceName).getOperation(new QName(operationName));
            od.engageModule(this.configContext.getAxisConfiguration().getModule(moduleName));
            redirect.withStatus(true, moduleName + " module engaged to the operation successfully");
        }
        catch (AxisFault axisFault) {
            redirect.withStatus(false, axisFault.getMessage());
        }
        return redirect;
    }

    @Action(name="engageToService")
    public View engageToService(HttpServletRequest req) {
        HashMap modules = this.configContext.getAxisConfiguration().getModules();
        req.getSession().setAttribute("modulemap", (Object)modules);
        this.populateSessionInformation(req);
        req.getSession().setAttribute("engagestatus", null);
        req.getSession().setAttribute("modules", null);
        req.getSession().setAttribute("engagestatus", null);
        req.getSession().setAttribute("axisService", null);
        return new View("engageToService.jsp");
    }

    @Action(name="doEngageToService", post=true)
    public Redirect doEngageToService(HttpServletRequest request) {
        String moduleName = request.getParameter("module");
        String serviceName = request.getParameter("axisService");
        try {
            this.configContext.getAxisConfiguration().getService(serviceName).engageModule(this.configContext.getAxisConfiguration().getModule(moduleName));
            return new Redirect("engageToService").withStatus(true, moduleName + " module engaged to the service successfully");
        }
        catch (AxisFault axisFault) {
            return new Redirect("engageToService").withStatus(false, axisFault.getMessage());
        }
    }

    @Action(name="engageToServiceGroup")
    public View engageToServiceGroup(HttpServletRequest req) {
        HashMap modules = this.configContext.getAxisConfiguration().getModules();
        req.getSession().setAttribute("modulemap", (Object)modules);
        Iterator services = this.configContext.getAxisConfiguration().getServiceGroups();
        req.getSession().setAttribute("serviceGroupmap", (Object)services);
        req.getSession().setAttribute("engagestatus", null);
        req.getSession().setAttribute("modules", null);
        req.getSession().setAttribute("engagestatus", null);
        req.getSession().setAttribute("axisService", null);
        return new View("engageToServiceGroup.jsp");
    }

    @Action(name="doEngageToServiceGroup", post=true)
    public Redirect doEngageToServiceGroup(HttpServletRequest request) throws AxisFault {
        String moduleName = request.getParameter("module");
        String serviceName = request.getParameter("axisService");
        this.configContext.getAxisConfiguration().getServiceGroup(serviceName).engageModule(this.configContext.getAxisConfiguration().getModule(moduleName));
        return new Redirect("engageToServiceGroup").withStatus(true, moduleName + " module engaged to the service group successfully");
    }

    @Action(name="logout")
    public Redirect logout(HttpServletRequest req) {
        req.getSession().invalidate();
        return new Redirect("welcome");
    }

    @Action(name="viewServiceGroupContext")
    public View viewServiceGroupContext(HttpServletRequest req) {
        String type = req.getParameter("TYPE");
        String sgID = req.getParameter("ID");
        ServiceGroupContext sgContext = this.configContext.getServiceGroupContext(sgID);
        req.getSession().setAttribute("ServiceGroupContext", (Object)sgContext);
        req.getSession().setAttribute("TYPE", (Object)type);
        req.getSession().setAttribute("ConfigurationContext", (Object)this.configContext);
        return new View("viewServiceGroupContext.jsp");
    }

    @Action(name="viewServiceContext")
    public View viewServiceContext(HttpServletRequest req) throws AxisFault {
        String type = req.getParameter("TYPE");
        String sgID = req.getParameter("PID");
        String ID = req.getParameter("ID");
        ServiceGroupContext sgContext = this.configContext.getServiceGroupContext(sgID);
        if (sgContext != null) {
            AxisService service = sgContext.getDescription().getService(ID);
            ServiceContext serviceContext = sgContext.getServiceContext(service);
            req.setAttribute("ServiceContext", (Object)serviceContext);
            req.setAttribute("TYPE", (Object)type);
        } else {
            req.setAttribute("ServiceContext", null);
            req.setAttribute("TYPE", (Object)type);
        }
        return new View("viewServiceContext.jsp");
    }

    @Action(name="selectServiceParaEdit")
    public View selectServiceParaEdit(HttpServletRequest req) {
        this.populateSessionInformation(req);
        req.getSession().setAttribute("SELECT_SERVICE_TYPE", (Object)"SERVICE_PARAMETER");
        req.setAttribute("action", (Object)"editServiceParameters");
        return new View("SelectService.jsp");
    }

    @Action(name="listOperation")
    public View listOperation(HttpServletRequest req) {
        this.populateSessionInformation(req);
        req.getSession().setAttribute("SELECT_SERVICE_TYPE", (Object)"MODULE");
        req.setAttribute("action", (Object)"engageToOperation");
        return new View("SelectService.jsp");
    }

    @Action(name="activateService")
    public View activateService(HttpServletRequest req) {
        this.populateSessionInformation(req);
        return new View("activateService.jsp");
    }

    @Action(name="doActivateService", post=true)
    public Redirect doActivateService(HttpServletRequest request) throws AxisFault {
        String serviceName = request.getParameter("axisService");
        String turnon = request.getParameter("turnon");
        if (serviceName != null && turnon != null) {
            this.configContext.getAxisConfiguration().startService(serviceName);
        }
        return new Redirect("activateService");
    }

    @Action(name="deactivateService")
    public View deactivateService(HttpServletRequest req) {
        this.populateSessionInformation(req);
        return new View("deactivateService.jsp");
    }

    @Action(name="doDeactivateService", post=true)
    public Redirect doDeactivateService(HttpServletRequest request) throws AxisFault {
        String serviceName = request.getParameter("axisService");
        String turnoff = request.getParameter("turnoff");
        if (serviceName != null && turnoff != null) {
            this.configContext.getAxisConfiguration().stopService(serviceName);
        }
        return new Redirect("deactivateService");
    }

    @Action(name="viewGlobalChains")
    public View viewGlobalChains(HttpServletRequest req) {
        req.getSession().setAttribute("axisconfig", (Object)this.configContext.getAxisConfiguration());
        return new View("viewGlobalChains.jsp");
    }

    @Action(name="viewOperationSpecificChains")
    public View viewOperationSpecificChains(HttpServletRequest req) throws AxisFault {
        String service = req.getParameter("axisService");
        if (service != null) {
            req.getSession().setAttribute("serviceHandlers", (Object)this.configContext.getAxisConfiguration().getService(service));
        }
        return new View("viewOperationSpecificChains.jsp");
    }

    @Action(name="listPhases")
    public View listPhases(HttpServletRequest req) {
        PhasesInfo info = this.configContext.getAxisConfiguration().getPhasesInfo();
        req.getSession().setAttribute("phaseList", (Object)info);
        return new View("viewphases.jsp");
    }

    @Action(name="listServiceGroups")
    public View listServiceGroups(HttpServletRequest req) {
        Iterator serviceGroups = this.configContext.getAxisConfiguration().getServiceGroups();
        this.populateSessionInformation(req);
        req.getSession().setAttribute("serviceGroupmap", (Object)serviceGroups);
        return new View("listServiceGroups.jsp");
    }

    @Action(name="listServices")
    public View listServices(HttpServletRequest req) {
        this.populateSessionInformation(req);
        req.getSession().setAttribute("errprservicemap", (Object)this.configContext.getAxisConfiguration().getFaultyServices());
        return new View("listServices.jsp");
    }

    @Action(name="listSingleService")
    public View listSingleService(HttpServletRequest req) throws AxisFault {
        req.getSession().setAttribute("Fault", (Object)"");
        String serviceName = req.getParameter("serviceName");
        if (serviceName != null) {
            AxisService service = this.configContext.getAxisConfiguration().getService(serviceName);
            req.getSession().setAttribute("singleservice", (Object)service);
        }
        return new View("listSingleService.jsp");
    }

    @Action(name="viewContexts")
    public View viewContexts(HttpServletRequest req) {
        req.getSession().setAttribute("config_context", (Object)this.configContext);
        return new View("viewContexts.jsp");
    }

    @Action(name="globalModules")
    public View globalModules(HttpServletRequest req) {
        Collection modules = this.configContext.getAxisConfiguration().getEngagedModules();
        req.getSession().setAttribute("modulemap", (Object)modules);
        return new View("globalModules.jsp");
    }

    @Action(name="listModules")
    public View listModules(HttpServletRequest req) {
        HashMap modules = this.configContext.getAxisConfiguration().getModules();
        req.getSession().setAttribute("modulemap", (Object)modules);
        req.getSession().setAttribute("errormodulesmap", (Object)this.configContext.getAxisConfiguration().getFaultyModules());
        return new View("listModules.jsp");
    }

    @Action(name="disengageModule", post=true)
    public Redirect processdisengageModule(HttpServletRequest req) throws AxisFault {
        String type = req.getParameter("type");
        String serviceName = req.getParameter("serviceName");
        String moduleName = req.getParameter("module");
        AxisConfiguration axisConfiguration = this.configContext.getAxisConfiguration();
        AxisService service = axisConfiguration.getService(serviceName);
        AxisModule module = axisConfiguration.getModule(moduleName);
        if (type.equals("operation")) {
            if (service.isEngaged(module.getName()) || axisConfiguration.isEngaged(module.getName())) {
                return new Redirect("listServices").withStatus(false, "Can not disengage module " + moduleName + ". This module is engaged at a higher level.");
            }
            String opName = req.getParameter("operation");
            AxisOperation op = service.getOperation(new QName(opName));
            op.disengageModule(module);
            return new Redirect("listServices").withStatus(true, "Module " + moduleName + " was disengaged from " + "operation " + opName + " in service " + serviceName + ".");
        }
        if (axisConfiguration.isEngaged(module.getName())) {
            return new Redirect("listServices").withStatus(false, "Can not disengage module " + moduleName + ". " + "This module is engaged at a higher level.");
        }
        service.disengageModule(axisConfiguration.getModule(moduleName));
        return new Redirect("listServices").withStatus(true, "Module " + moduleName + " was disengaged from" + " service " + serviceName + ".");
    }

    @Action(name="deleteService", post=true)
    public Redirect deleteService(HttpServletRequest req) throws AxisFault {
        String serviceName = req.getParameter("serviceName");
        AxisConfiguration axisConfiguration = this.configContext.getAxisConfiguration();
        if (axisConfiguration.getService(serviceName) != null) {
            axisConfiguration.removeService(serviceName);
            return new Redirect("listServices").withStatus(true, "Service '" + serviceName + "' has been successfully removed.");
        }
        return new Redirect("listServices").withStatus(false, "Failed to delete service '" + serviceName + "'. Service doesn't exist.");
    }

    @Action(name="selectService")
    public View selectService(HttpServletRequest req) {
        this.populateSessionInformation(req);
        req.getSession().setAttribute("SELECT_SERVICE_TYPE", (Object)"VIEW");
        req.setAttribute("action", (Object)"viewOperationSpecificChains");
        return new View("SelectService.jsp");
    }
}

