/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.jodatime;

import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.jodatime.DateColumnType;
import org.jetbrains.exposed.sql.jodatime.DateColumnTypeKt;
import org.jetbrains.exposed.sql.jodatime.DateTimeWithTimeZoneColumnType;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016\u001a\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016\u001a\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"#\u0010\u0004\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\"#\u0010\t\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006\"\u0016\u0010\f\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\r\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"#\u0010\u000e\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\b\u001a\u0004\b\u000f\u0010\u0006\u00a8\u0006\u001d"}, d2={"DEFAULT_DATE_STRING_FORMATTER", "Lorg/joda/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "DEFAULT_DATE_TIME_STRING_FORMATTER", "DEFAULT_DATE_TIME_WITH_TIME_ZONE_FORMATTER", "getDEFAULT_DATE_TIME_WITH_TIME_ZONE_FORMATTER", "()Lorg/joda/time/format/DateTimeFormatter;", "DEFAULT_DATE_TIME_WITH_TIME_ZONE_FORMATTER$delegate", "Lkotlin/Lazy;", "MYSQL_DATE_TIME_WITH_TIME_ZONE_FORMATTER", "getMYSQL_DATE_TIME_WITH_TIME_ZONE_FORMATTER", "MYSQL_DATE_TIME_WITH_TIME_ZONE_FORMATTER$delegate", "SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER", "SQLITE_DATE_STRING_FORMATTER", "SQLITE_DATE_TIME_WITH_TIME_ZONE_FORMATTER", "getSQLITE_DATE_TIME_WITH_TIME_ZONE_FORMATTER", "SQLITE_DATE_TIME_WITH_TIME_ZONE_FORMATTER$delegate", "dateTimeWithFractionFormat", "fraction", "", "formatterForDateTimeString", "date", "", "Lorg/jetbrains/exposed/sql/Column;", "Lorg/joda/time/DateTime;", "Lorg/jetbrains/exposed/sql/Table;", "name", "datetime", "timestampWithTimeZone", "exposed-jodatime"})
public final class DateColumnTypeKt {
    private static final DateTimeFormatter DEFAULT_DATE_STRING_FORMATTER = DateTimeFormat.forPattern((String)"YYYY-MM-dd").withLocale(Locale.ROOT);
    private static final DateTimeFormatter DEFAULT_DATE_TIME_STRING_FORMATTER = DateTimeFormat.forPattern((String)"YYYY-MM-dd HH:mm:ss.SSSSSS").withLocale(Locale.ROOT);
    private static final DateTimeFormatter SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER = DateTimeFormat.forPattern((String)"YYYY-MM-dd HH:mm:ss.SSS");
    private static final DateTimeFormatter SQLITE_DATE_STRING_FORMATTER = ISODateTimeFormat.yearMonthDay();
    @NotNull
    private static final Lazy SQLITE_DATE_TIME_WITH_TIME_ZONE_FORMATTER$delegate = LazyKt.lazy((Function0)SQLITE_DATE_TIME_WITH_TIME_ZONE_FORMATTER.2.INSTANCE);
    @NotNull
    private static final Lazy MYSQL_DATE_TIME_WITH_TIME_ZONE_FORMATTER$delegate = LazyKt.lazy((Function0)MYSQL_DATE_TIME_WITH_TIME_ZONE_FORMATTER.2.INSTANCE);
    @NotNull
    private static final Lazy DEFAULT_DATE_TIME_WITH_TIME_ZONE_FORMATTER$delegate = LazyKt.lazy((Function0)DEFAULT_DATE_TIME_WITH_TIME_ZONE_FORMATTER.2.INSTANCE);

    private static final DateTimeFormatter getSQLITE_DATE_TIME_WITH_TIME_ZONE_FORMATTER() {
        Lazy lazy = SQLITE_DATE_TIME_WITH_TIME_ZONE_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getMYSQL_DATE_TIME_WITH_TIME_ZONE_FORMATTER() {
        Lazy lazy = MYSQL_DATE_TIME_WITH_TIME_ZONE_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getDEFAULT_DATE_TIME_WITH_TIME_ZONE_FORMATTER() {
        Lazy lazy = DEFAULT_DATE_TIME_WITH_TIME_ZONE_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter formatterForDateTimeString(String date) {
        return DateColumnTypeKt.dateTimeWithFractionFormat(StringsKt.substringAfterLast((String)date, (char)'.', (String)"").length());
    }

    private static final DateTimeFormatter dateTimeWithFractionFormat(int fraction) {
        String baseFormat = "YYYY-MM-dd HH:mm:ss";
        String newFormat = baseFormat + ((1 <= fraction ? fraction < 10 : false) ? '.' + StringsKt.repeat((CharSequence)"S", (int)fraction) : "");
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)newFormat);
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"forPattern(newFormat)");
        return dateTimeFormatter;
    }

    @NotNull
    public static final Column<DateTime> date(@NotNull Table $this$date, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$date, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$date.registerColumn(name, (IColumnType)new DateColumnType(false));
    }

    @NotNull
    public static final Column<DateTime> datetime(@NotNull Table $this$datetime, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$datetime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$datetime.registerColumn(name, (IColumnType)new DateColumnType(true));
    }

    @NotNull
    public static final Column<DateTime> timestampWithTimeZone(@NotNull Table $this$timestampWithTimeZone, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$timestampWithTimeZone, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$timestampWithTimeZone.registerColumn(name, (IColumnType)new DateTimeWithTimeZoneColumnType());
    }

    public static final /* synthetic */ DateTimeFormatter access$getDEFAULT_DATE_TIME_STRING_FORMATTER$p() {
        return DEFAULT_DATE_TIME_STRING_FORMATTER;
    }

    public static final /* synthetic */ DateTimeFormatter access$getDEFAULT_DATE_STRING_FORMATTER$p() {
        return DEFAULT_DATE_STRING_FORMATTER;
    }

    public static final /* synthetic */ DateTimeFormatter access$formatterForDateTimeString(String date) {
        return DateColumnTypeKt.formatterForDateTimeString(date);
    }

    public static final /* synthetic */ DateTimeFormatter access$getSQLITE_DATE_STRING_FORMATTER$p() {
        return SQLITE_DATE_STRING_FORMATTER;
    }

    public static final /* synthetic */ DateTimeFormatter access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER$p() {
        return SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER;
    }

    public static final /* synthetic */ DateTimeFormatter access$getSQLITE_DATE_TIME_WITH_TIME_ZONE_FORMATTER() {
        return DateColumnTypeKt.getSQLITE_DATE_TIME_WITH_TIME_ZONE_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$getMYSQL_DATE_TIME_WITH_TIME_ZONE_FORMATTER() {
        return DateColumnTypeKt.getMYSQL_DATE_TIME_WITH_TIME_ZONE_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$getDEFAULT_DATE_TIME_WITH_TIME_ZONE_FORMATTER() {
        return DateColumnTypeKt.getDEFAULT_DATE_TIME_WITH_TIME_ZONE_FORMATTER();
    }
}

