/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.jodatime;

import java.sql.ResultSet;
import java.sql.Timestamp;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.jodatime.DateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/exposed/sql/jodatime/DateTimeWithTimeZoneColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "nonNullValueToString", "", "value", "", "notNullValueToDB", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "sqlType", "valueFromDB", "Lorg/joda/time/DateTime;", "Companion", "exposed-jodatime"})
public final class DateTimeWithTimeZoneColumnType
extends ColumnType
implements IDateColumnType {
    @NotNull
    public static final Companion Companion;
    private final boolean hasTimePart;
    @Nullable
    private static final Class<?> offsetDateTimeClass;

    public DateTimeWithTimeZoneColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().timestampWithTimeZoneType();
    }

    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof DateTime) {
        } else {
            throw new IllegalStateException(("Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        DatabaseDialect databaseDialect = DefaultKt.getCurrentDialect();
        return databaseDialect instanceof SQLiteDialect ? '\'' + DateColumnTypeKt.access$getSQLITE_DATE_TIME_WITH_TIME_ZONE_FORMATTER().print((ReadableInstant)value) + '\'' : (databaseDialect instanceof MysqlDialect ? '\'' + DateColumnTypeKt.access$getMYSQL_DATE_TIME_WITH_TIME_ZONE_FORMATTER().print((ReadableInstant)value) + '\'' : '\'' + DateColumnTypeKt.access$getDEFAULT_DATE_TIME_WITH_TIME_ZONE_FORMATTER().print((ReadableInstant)value) + '\'');
    }

    @NotNull
    public DateTime valueFromDB(@NotNull Object value) {
        DateTime dateTime;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (Intrinsics.areEqual(value.getClass(), offsetDateTimeClass)) {
            DateTime dateTime2 = DateTime.parse((String)value.toString());
            dateTime = dateTime2;
            Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"parse(value.toString())");
        } else if (value instanceof String) {
            DateTime dateTime3 = DefaultKt.getCurrentDialect() instanceof SQLiteDialect ? DateTime.parse((String)((String)value), (DateTimeFormatter)DateColumnTypeKt.access$getSQLITE_DATE_TIME_WITH_TIME_ZONE_FORMATTER()) : DateTime.parse((String)((String)value));
            Intrinsics.checkNotNullExpressionValue((Object)dateTime3, (String)"{\n            if (curren\u2026)\n            }\n        }");
            dateTime = dateTime3;
        } else {
            throw new IllegalStateException(("Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return dateTime;
    }

    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        return DefaultKt.getCurrentDialect() instanceof SQLiteDialect ? super.readObject(rs, index) : (offsetDateTimeClass != null ? rs.getObject(index, offsetDateTimeClass) : super.readObject(rs, index));
    }

    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof DateTime) {
        } else {
            throw new IllegalStateException(("Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        DatabaseDialect databaseDialect = DefaultKt.getCurrentDialect();
        Object object = databaseDialect instanceof SQLiteDialect ? DateColumnTypeKt.access$getSQLITE_DATE_TIME_WITH_TIME_ZONE_FORMATTER().print((ReadableInstant)value) : (databaseDialect instanceof MysqlDialect ? DateColumnTypeKt.access$getMYSQL_DATE_TIME_WITH_TIME_ZONE_FORMATTER().print((ReadableInstant)value) : new Timestamp(((DateTime)value).getMillis()));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"when (value) {\n        i\u2026ss.qualifiedName}\")\n    }");
        return object;
    }

    static {
        Class<?> clazz;
        Companion = new Companion(null);
        try {
            clazz = Class.forName("java.time.OffsetDateTime", false, Companion.getClass().getClassLoader());
        }
        catch (ClassNotFoundException _) {
            clazz = null;
        }
        offsetDateTimeClass = clazz;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/jodatime/DateTimeWithTimeZoneColumnType$Companion;", "", "()V", "offsetDateTimeClass", "Ljava/lang/Class;", "exposed-jodatime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

